# finaquant Financial Analytics - www.finaquant.com
# Copyright: Tunc Ali Ktkcoglu  2012, version: 28Mar2012
# TITLE: Simple Performance Fee Calculation for Investment Funds
# Related web page:
# http://finaquant.com/simple-performance-fee-calculation-for-investment-funds/760

# help function for displaying variables
display_variable = function(v, vname) { 
print(paste(vname,' ='),quote = FALSE)
print(v,quote = FALSE)
}
# help function to calculate absolute asset values for given returns
convert_Returns_to_AssetValues = function(InitialValue, ReturnsVec) { 
ReturnsVec = c(0,ReturnsVec)
AssetValues = InitialValue * cumprod(1 + ReturnsVec)
return(AssetValues)
}
# help function to calculate High Watermarks
calculate_HWM = function(AssetValues){
VectorLen = length(AssetValues)
HWM = rep(0, VectorLen)
HWM[1] = AssetValues[1]

	for (i in 2:VectorLen) {
		if (AssetValues[i] > HWM[i-1]) {
			HWM[i] = AssetValues[i]
		} else {
			HWM[i] = HWM[i-1]
		}
	}
return(HWM)
}

# generate vectors NAVps and benchmark returns
N = 50	 # vector length
x = 1:N
y = 1:(N+1)
InitialNAVps = 10

# hypothetical benchmark returns
BenchmarkReturns = 0.02 + 0.03 * sin((x+5)*2*pi/(N/4)) * sqrt(1 + x/N) / sqrt(2)
# construct benchmark values
BenchmarkValues = convert_Returns_to_AssetValues(InitialNAVps, BenchmarkReturns)

# hypothetical fund returns and NAVps
FundReturns = 0.02 + BenchmarkReturns + 0.03 * sin((x-5)*2*pi/(N/6))
NAVps = convert_Returns_to_AssetValues(InitialNAVps, FundReturns)

# plot fund returns against benchmark returns
plot(x, FundReturns, col="blue",xlab='time (periods)',ylab='return',main='fund (blue) vs benchmark returns (red)',type='l')
lines(x,BenchmarkReturns,col="red")
dev.new()

# plot NAVps against benchmark values
plot(y, NAVps, col="blue",xlab='time (periods)',ylab='values',main='fund (blue) vs benchmark values (red)',type='l')
lines(y,BenchmarkValues,col="red")
dev.new()

print('***********************************************************************')
print('Big test')
print('***********************************************************************')
# input parameters
FeeRate = 0.20
HurdleRate = 0.01
applyHWM = FALSE
FloorPs = -999999999   	# set to -999999999 for no floor
CapPs = 999999999     	# set to 999999999 for no cap

# file must be in the same working directory
source('function_SimplePerformanceFee.R')

# all inputs are ready; run simple performance fee function
results = SimplePerformanceFee(NAVps,BenchmarkReturns,applyHWM,FeeRate,HurdleRate,FloorPs,CapPs)

# outputs
Outperform = results[[1]]
FundReturn = results[[2]]
ExcessReturn = results[[3]]
RelativeValues = results[[4]]
rHWM = results[[5]]
FeeBeforeCF = results[[6]]
PerfFeePs = results[[7]]

# total performance fee paid over all periods
display_variable(sum(PerfFeePs), 'Total fees paid')

# plot excess return and performance fee per share
plot(x,PerfFeePs, col="red",xlab='time (periods)',ylab='% and $',main='excess return (blue) vs performance fee ps (red)',type='l')
lines(x,ExcessReturn,col="blue")

print('***********************************************************************')
print('Simple test')
print('***********************************************************************')
# input parameters
NAVps = c(100, 110, 120, 130)
BenchmarkReturns = c(0, 0, 0)
FeeRate = 0.20
HurdleRate = 0.01
applyHWM = FALSE
FloorPs = -999999999   # set to -999999999 for no floor
CapPs = 999999999      # set to 999999999 for no cap

# all inputs are ready; run simple performance fee function
results = SimplePerformanceFee(NAVps,BenchmarkReturns,applyHWM,FeeRate,HurdleRate,FloorPs,CapPs)

# total performance fee paid over all periods
display_variable(sum(results[[7]]), 'Total fees paid')

